// rfid1demoDlg.cpp : implementation file
#include "stdafx.h"
#include "rfid1demo.h"
#include "rfid1demoDlg.h"
//#include "FTD2XX.h"
#include <compplib.hpp>
#include "PortSel.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



//serial io Stuff
GFComWin32 *sio;
GFSerial *cp;
GFDataFormat *df; //for setting baud rate


#define ascitohex(c)    (c <= '9' ? c - '0' : ((c <= 'F') ? c-'A'+10 : c - 'a'+10 ))

#define MYBUFFERSIZE 3000
unsigned char grx[MYBUFFERSIZE];//global receive buffer

int m_SerPortSelected;


int valid_port;
int	process_active;
//FT_HANDLE m_ftHandle;

int BatchRunning=0;
CString g_str_array[300];

int data8[8];//array for holding 8 blocks



// CAboutDlg dialog used for App About
class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRfid1demoDlg dialog

CRfid1demoDlg::CRfid1demoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRfid1demoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRfid1demoDlg)
	m_NumTags = _T("");
	m_MyText = _T("");
	m_PortStatus = _T("");
	m_NumChars = 0;
	m_Addr = _T("00");
	m_Data = _T("");
	m_ReadInputs = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CRfid1demoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRfid1demoDlg)
	DDX_Control(pDX, IDC_LIST2, m_SniffList);
	DDX_Control(pDX, IDC_PROGRESS1, m_Progress);
	DDX_Control(pDX, IDC_LIST1,  m_BigBuf);
	DDX_Text(pDX, IDC_EDIT_NUMTAGS, m_NumTags);
	DDX_Text(pDX, IDC_EDIT_MYTEXT, m_MyText);
	DDV_MaxChars(pDX, m_MyText, 256);
	DDX_Text(pDX, IDC_EDIT_STATUS, m_PortStatus);
	DDX_Text(pDX, IDC_EDIT_NUM_CHARS, m_NumChars);
	DDX_Text(pDX, IDC_EDIT_BLOCK_ADDR, m_Addr);
	DDX_Text(pDX, IDC_EDIT_BLOCK_32BITDATA2, m_Data);
	DDX_Text(pDX, IDC_EDIT_READ_INPUTS, m_ReadInputs);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CRfid1demoDlg, CDialog)
	//{{AFX_MSG_MAP(CRfid1demoDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_START, OnButtonStart)
	ON_BN_CLICKED(IDC_BUTTON_STOP, OnButtonStop)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTONREAD, OnButtonread)
	ON_EN_CHANGE(IDC_EDIT_MYTEXT, OnChangeEditMytext)
	ON_BN_CLICKED(IDC_BUTTON_CLEAR, OnButtonClear)
	ON_BN_CLICKED(IDC_BUTTON_WRITE_TAG, OnButtonWriteTag)
	ON_BN_CLICKED(IDC_BUTTON_TEST_PATTERN, OnButtonTestPattern)
	ON_BN_CLICKED(IDC_BUTTON_PASS_BEEP, OnButtonPassBeep)
	ON_BN_CLICKED(IDC_BUTTON_FAIL_BEEP, OnButtonFailBeep)
	ON_BN_CLICKED(IDC_BUTTON_WRITE_SINGLE, OnButtonWriteSingle)
	ON_BN_CLICKED(IDC_BUTTON_READ_BLOCK, OnButtonReadBlock)
	ON_BN_CLICKED(IDC_BUTTON_STAY_QUIET, OnButtonStayQuiet)
	ON_BN_CLICKED(IDC_BUTTON_R1, OnButtonR1)
	ON_BN_CLICKED(IDC_BUTTON_R2, OnButtonR2)
	ON_BN_CLICKED(IDC_BUTTON_R3, OnButtonR3)
	ON_BN_CLICKED(IDC_BUTTON_R4, OnButtonR4)
	ON_BN_CLICKED(IDC_BUTTON_R5, OnButtonR5)
	ON_BN_CLICKED(IDC_BUTTON_R6, OnButtonR6)
	ON_BN_CLICKED(IDC_BUTTON_O1H, OnButtonO1h)
	ON_BN_CLICKED(IDC_BUTTON_O1L, OnButtonO1l)
	ON_BN_CLICKED(IDC_BUTTON_O2H, OnButtonO2h)
	ON_BN_CLICKED(IDC_BUTTON_O2L, OnButtonO2l)
	ON_BN_CLICKED(IDC_BUTTON_READ_IO, OnButtonReadIo)
	ON_BN_CLICKED(IDC_BUTTON_CHANGE_PORT, OnButtonChangePort)
	ON_BN_CLICKED(IDC_BUTTON_RESET, OnButtonReset)
	ON_BN_CLICKED(IDC_BUTTON_R7, OnButtonR7)
	ON_BN_CLICKED(IDC_BUTTON_R8, OnButtonR8)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRfid1demoDlg message handlers

void CRfid1demoDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CRfid1demoDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CRfid1demoDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


//**********************************************************************************************
BOOL CRfid1demoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	valid_port=0;
	process_active=0;

	m_SerPortSelected=11;

	OpenPort(1, 1);//reset, beep, notify_open in listbox




	return TRUE;  // return TRUE  unless you set the focus to a control
}




//**********************************************************************************************
int CRfid1demoDlg::OpenPort(int beep, int notify_open)
{
	int res;
	CString sss;

	
	UpdateData(TRUE); //read current data from the window
    m_PortStatus = _T("Testing...");
 	UpdateData(FALSE);
	UpdateWindow();

	if(df)
	{
		delete df;
		df = 0;	
	}

	if(cp)
	{
	   delete cp;
       cp = 0;
	}
	
	if(sio)
	{
	   delete sio;
       sio = 0;
	}

	if(m_SerPortSelected == 1) 
		sio = :: new GFComWin32( COM1 );
	if(m_SerPortSelected == 2) 
		sio = :: new GFComWin32( COM2 );
	if(m_SerPortSelected == 3) 
		sio = :: new GFComWin32( COM3 );
	if(m_SerPortSelected == 4) 
		sio = :: new GFComWin32( COM4 );
	if(m_SerPortSelected == 5) 
		sio = :: new GFComWin32( COM5 );
	if(m_SerPortSelected == 6) 
		sio = :: new GFComWin32( COM6 );
	if(m_SerPortSelected == 7) sio = :: new GFComWin32( COM7 );
	if(m_SerPortSelected == 8) sio = :: new GFComWin32( COM8 );
	if(m_SerPortSelected == 9) sio = :: new GFComWin32( COM9 );
	if(m_SerPortSelected == 10)sio = :: new GFComWin32( COM10 );
	if(m_SerPortSelected == 11)
		sio = :: new GFComWin32( COM11 );
	if(m_SerPortSelected == 12)sio = :: new GFComWin32( COM12 );
	if(m_SerPortSelected == 13)sio = :: new GFComWin32( COM13 );
	if(m_SerPortSelected == 14)sio = :: new GFComWin32( COM14 );
	if(m_SerPortSelected == 15)sio = :: new GFComWin32( COM15 );
	if(m_SerPortSelected == 18)sio = :: new GFComWin32( COM18 );

	cp = ::new GFSerial(sio);
	unsigned short err = 0;
    if( cp->GetCommError(err) != GCPP_OK )//test for serial port active
	{
		m_PortStatus.Format("COM%d:No Port", m_SerPortSelected);
		UpdateData(FALSE);
		UpdateWindow();
		//AfxMessageBox("Error: failed to open port.");				
		return 1;
	}

	df = ::new GFDataFormat(cp);
	int result = df->SetUp(115200, 'N', 8, 1);
	if(result != GCPP_OK)
	{
		m_PortStatus = _T("Error setting Baud Rate.");
		UpdateData(FALSE);
		UpdateWindow();
		return 1;
	}

Sleep(1000);

	res = PingReader();
	if(res==0)//no error
	{
		if(beep)
			//SendBeep1();
			OnButtonPassBeep(); 

		if(notify_open)
		{
			sss.Format("Port Open, RFID1 Ready");
			m_SniffList.InsertString(0,sss);
			UpdateWindow();
		}
	}
	else
	{
		sss.Format("No RFID1 Detected");
		m_SniffList.InsertString(0,sss);
		UpdateWindow();
		//AfxMessageBox("Error: No reader detected.");				
		return 2;
	}


	Sleep(500);
	DWORD AmountInRxQueue = cp->RXCount();

	unsigned char rx[60];
	while(AmountInRxQueue>0)
	{
		cp->GetBuffer(rx, 1, 100); 
		Sleep(1);
		AmountInRxQueue = cp->RXCount();
	}


	return 0;
}




//**********************************************************************************************
int CRfid1demoDlg::PingReader() 
{
	unsigned char tx[600], rx[600];
	CString stra, str, sss;


	//wait for the power up LED flash to complete
	Sleep(800);


	//send a zero to stop the data spewing
	int pos=0;
	tx[pos++] = 0x30;
	cp->PutBuffer(tx, pos);


	DWORD AmountInRxQueue = cp->RXCount();

	while(AmountInRxQueue>0)
	{
		if(AmountInRxQueue >500) AmountInRxQueue=500;
		cp->GetBuffer(rx, AmountInRxQueue, 100); 
		Sleep(1);
		AmountInRxQueue = cp->RXCount();
		AmountInRxQueue=AmountInRxQueue;
	}

	AmountInRxQueue = cp->RXCount();

	PurgePort();


	//Ping the port and check for correct response
	pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x38;//8

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x46;//F
		
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	cp->PutBuffer(tx, pos);
	Sleep(350);
	DWORD ret_bytes = cp->RXCount();
	cp->GetBuffer(rx, ret_bytes, 100); 
	
	
	if(ret_bytes < 3)
	{
		sss.Format("RFID1 not found");
		m_SniffList.InsertString(0,sss);
		UpdateWindow();
		return 1;
	}


	for(DWORD x=0; x<ret_bytes; x++)
	{
		stra.Format("%c", rx[x]);
		str+=stra;
	}

	int loc1 = str.Find("DLP-RFID", 0);
	int loc2 = str.Find("TRF7960 EVM", 0);

	if( (loc1 == 0xffffffff) && (loc2 == 0xffffffff) )
	{
		//fail
		sss.Format("RFID1 not found");
		m_SniffList.InsertString(0,sss);
		UpdateWindow();
		return 2;
	}
	else
	{
		//pass
		valid_port=1;//this is the only place valid_port can be set
		PurgePort();
	}
	
	AmountInRxQueue = cp->RXCount();

	int ret = PurgePort();
	//if(ret)//if any data is still in the buffer then warn
	//	AfxMessageBox("Warning: extra data in buffer...");

	return 0;
}









//**********************************************************************
int CRfid1demoDlg::PurgePort()
{
	int total_bytes_found;
	DWORD AmountInRxQueue, BytesReturned;

	Sleep(30);
	AmountInRxQueue = cp->RXCount();
	total_bytes_found=AmountInRxQueue;//init counter
	while(AmountInRxQueue)
	{
		BytesReturned = cp->GetBuffer(grx, AmountInRxQueue, 100); 
		Sleep(10);//wait for more to arrive
		AmountInRxQueue = cp->RXCount();
		total_bytes_found += AmountInRxQueue;
	}

	for(int x=0; x<MYBUFFERSIZE; x++)
		grx[x]=0xcc;

	return total_bytes_found;
}


//**********************************************************************
DWORD CRfid1demoDlg::FastRead(int count, int timeout)
{
	DWORD AmountInRxQueue, BytesReturned;

	
	if(count>MYBUFFERSIZE)
	{
		KillTimer(100);
		AfxMessageBox("array error 2");
		return 1;
	}

	
	AmountInRxQueue = cp->RXCount();

	AmountInRxQueue=0;
	while((timeout--) && (AmountInRxQueue<(DWORD)count))
	{
		Sleep(1);
		AmountInRxQueue = cp->RXCount();
	}


	if(AmountInRxQueue <= (DWORD)count)
		BytesReturned = cp->GetBuffer(grx, AmountInRxQueue, 100); 
	else
		BytesReturned = cp->GetBuffer(grx, count, 100); 

	return AmountInRxQueue;
}



//**********************************************************************
void CRfid1demoDlg::SendRegwrtreq(int mode)//0=usermem, 1=UID //15693 Setup
{
	unsigned char tx[600];
	CString stra, str;

	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x43;//C

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
		
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x31;//1

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0

	//0=usermem, 1=UID
	if(mode==0)
		tx[pos++] = 0x30;// 0 for memory read/write
	if(mode==1)
		tx[pos++] = 0x32;// 2 for UID read

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	
	cp->PutBuffer(tx, pos);

	//debug here	
	int ret = FastRead(51, 50);
}




//**********************************************************************
void CRfid1demoDlg::SendAgcToggle() 
{
	unsigned char tx[600];
	CString stra, str;
	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0
		
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	
    cp->PutBuffer(tx, pos);
//debug here	
	int ret = FastRead(20, 50);

}




//**********************************************************************
void CRfid1demoDlg::SendAmPmToggle() 
{
	unsigned char tx[600];
	CString stra, str;

	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x31;//1
		
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x46;//F

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	
    cp->PutBuffer(tx, pos);
	//debug here	
	int ret = FastRead(20, 50);
}



//**********************************************************************
void CRfid1demoDlg::OnButton15693invReq() 
{
	char str_src[3000];
	char str_dest[3000];
	unsigned char tx[3000];
	DWORD ret_bytes, x;
	CString stra, str;

	m_SniffList.ResetContent();
	UpdateWindow();

	int ret = PurgePort();
	//if(ret)
	//	AfxMessageBox("data in buffer 4...");


	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x42;//B

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x34;//4
		
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x36;//6
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);

	int res = ret_bytes = FastRead(53, 50);

	m_SniffList.ResetContent();

	for(x=0; x<ret_bytes; x++)
	{
		if(grx[x] == '[')
		{
			x++;
			str.Format(" ");
			while(grx[x] != ',')
			{
				stra.Format("%c", grx[x]);
				x++;
				str+=stra;
			}
		
			if(str.GetLength() >6)//if a UID was found...
			{
				strcpy(str_src, (LPCTSTR)str);

				//byte reverse
				int ptr=15;
				for(int t=0; t<16; t+=2)
				{
					str_dest[t] = str_src[ptr];
					str_dest[t+1] = str_src[ptr+1];
					str_dest[t+2] = NULL;
					ptr-=2;
				}

				CString sss;
				sss.Format("%s", str_dest);
				m_SniffList.InsertString(0,"UID:"+sss);//display the UID
				UpdateWindow();
			}
		}
	}
}






//**********************************************************************
void CRfid1demoDlg::SendRegwrtreqTagit() 
{
	unsigned char tx[600];
	CString stra, str;
	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x43;//C

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
		
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x31;//1

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x33;//3

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0


//	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
    cp->PutBuffer(tx, pos);
	int ret = FastRead(53, 100);
	//if(ret != 53)
	//{
	//	KillTimer(100);
 	//	AfxMessageBox("fastread failed22");	
	//}

}


/*
	cp->PutBuffer(tx, pos);
	DWORD AmountInRxQueue = cp->RXCount();
	cp->GetBuffer(rx, AmountInRxQueue, 100); 
*/


//**********************************************************************
DWORD CRfid1demoDlg::GetBufferSlow()
{
	unsigned char temprx[3];
	DWORD AmountInRxQueue;
	int timeoutcount;
	int found=0, index=0;

	while(!found)//while have not timed out
	{
		timeoutcount=0;
		AmountInRxQueue=0;
		while (AmountInRxQueue==0)//wait for at least one byte in the buffer with timeout
		{
			AmountInRxQueue = cp->RXCount();
			if(AmountInRxQueue==0)//if no byte received then take a nap and wait for more bytes to arrive
				Sleep(10);

			timeoutcount++;
			if(timeoutcount>100)
				break;
		}

		if(AmountInRxQueue>0)//if one byte is ready to be read
		{
			timeoutcount=0;//reset timeout
			cp->GetBuffer(temprx, 1, 100); 

			grx[index++] = temprx[0];

			if(temprx[0] == '>')
				found=1;//terminate loop/function
			
			if(index > MYBUFFERSIZE-10)		
			{
				found=1;//terminate loop/function
				PurgePort();
			}
		}
		else//timeout
		{
			found=1;//terminate loop/function
			//PurgePort();//purge and return
		}
	}

	return index;
}




/*
	unsigned char temprx[3];
	DWORD AmountInRxQueue, BytesReturned;
	int timeoutcount;
	int found=0, index=0;

	while(!found)//while have not found the ">" character
	{
		timeoutcount=0;
		AmountInRxQueue=0;
		while (AmountInRxQueue==0)//wait for at least one byte in the buffer with timeout
		{
			timeoutcount++;
			if(timeoutcount>250)
				break;
			AmountInRxQueue = cp->RXCount();
			if(AmountInRxQueue==0)//if no byte received then take a nap and wait for more bytes to arrive
				Sleep(1);
		}

		if(AmountInRxQueue>0)//if one byte is ready to be read
		{
			BytesReturned = cp->GetBuffer(temprx, 1, 100); 

			if(temprx[0] == '>')//if > character received then set the flag and clear the buffer which should be empty
			{
				found=1;
				Sleep(30);
				AmountInRxQueue = cp->RXCount();
				while(AmountInRxQueue)
				{
					cp->GetBuffer(grx, AmountInRxQueue, 100); 
					Sleep(10);//wait for more to arrive
					AmountInRxQueue = cp->RXCount();
				}
			}

			grx[index++] = temprx[0];
			if(index > MYBUFFERSIZE-10)
			{
				found=1;//terminate loop/function
				int ret = PurgePort();
				index=0;
			}
		}
		else//timeout
		{
			PurgePort();//we got a timeout and likely a partial packet so purge and return
			return 0;
		}
	}

	return index;
}
*/



//**********************************************************************
void CRfid1demoDlg::OnButtonStart() 
{
	SetTimer(100, 200, NULL);
}
//**********************************************************************
void CRfid1demoDlg::OnButtonStop() 
{
	KillTimer(100);
}


//**********************************************************************
void CRfid1demoDlg::OnTimer(UINT nIDEvent) 
{
	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}

	if(process_active)
		return;
	process_active=1;

	ReadBoth();
	
	process_active=0;

	CDialog::OnTimer(nIDEvent);
}


//*********************************************************************
void CRfid1demoDlg::OnCancel()
{
	if(df)
	{
		delete df;
		df = 0;	
	}

	if(cp)
	{
	   delete cp;
       cp = 0;
	}
	
	if(sio)
	{
	   delete sio;
       sio = 0;
	}


    MSG message; 
    if(::PeekMessage(&message, NULL, 0, 0, PM_REMOVE)) 
    { 
		OnOK(); 
    } 
		else
	OnOK(); 


}




//**********************************************************************
void CRfid1demoDlg::ReadBoth() 
{
	char str_src[3000];
	char str_dest[3000];
	unsigned char tx[3000];
	DWORD ret_bytes, x;
	CString stra, str;
	int TotNumTags;
	CString sss;
	CString ssx;


	TotNumTags=0;

	SendRegwrtreq(1);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();

	Sleep(10);
	DWORD AmountInRxQueue = cp->RXCount();

	unsigned char rx[6];
	while(AmountInRxQueue>0)
	{
		cp->GetBuffer(rx, 1, 100); 
		Sleep(1);
		AmountInRxQueue = cp->RXCount();
	}


	m_SniffList.ResetContent();
	m_BigBuf.ResetContent();
	UpdateWindow();

	int ret = PurgePort();

	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x42;//B

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x36;//6
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	
	cp->PutBuffer(tx, pos);
	ret_bytes = GetBufferSlow();

	int index=0;
	str.Format(" ");
	for(x=0; x<ret_bytes; x++)
	{
		ssx.Format("%c", grx[x]);
		str+=ssx;
		if(grx[x] == ']')
		{
			ssx.Format(" %d - ", index++);
			m_BigBuf.InsertString(0, ssx+str);
			str.Format(" ");
		}
		if(grx[x] == '.')
		{
			m_BigBuf.InsertString(0, str);
			str.Format(" ");
		}
	}



	for(x=0; x<ret_bytes; x++)
	{
		if(grx[x] == '[')
		{
			x++;
			str.Format(" ");
			int indx=0;
			while(grx[x] != ',')
			{
				stra.Format("%c", grx[x]);
				x++;
				indx++;
				str+=stra;
				if(indx>35)
				{
					str.Format(" ");
					break;
				}
			}
		


			if(str.GetLength() >6)//if a UID was found...
			{
				strcpy(str_src, (LPCTSTR)str);

				//byte reverse
				int ptr=15;
				for(int t=0; t<16; t+=2)
				{
					str_dest[t] = str_src[ptr];
					str_dest[t+1] = str_src[ptr+1];
					str_dest[t+2] = NULL;
					ptr-=2;
				}

				str.Format(" ");
				while(grx[x] != ']')
				{
					stra.Format("%c", grx[x]);
					x++;					
					str+=stra;
				}

				sss.Format("%s", str_dest);
				m_SniffList.InsertString(0,"UID:"+sss+str);//display the UID
				TotNumTags++;
			}
		}
	}


	UpdateData(TRUE);
	m_NumTags.Format("%d tags", TotNumTags);
	UpdateData(FALSE);
	UpdateWindow();

	if(TotNumTags==0)
	{
		CString sss;
		sss.Format("NO      TAGS      FOUND");
		m_SniffList.InsertString(0,sss);
		m_SniffList.InsertString(0,sss);
		m_SniffList.InsertString(0,sss);
		m_SniffList.InsertString(0,sss);
		m_SniffList.InsertString(0,sss);
		UpdateWindow();
	}


	Sleep(70);//wait for any stragglers

	ret = PurgePort();
	//if(ret>1)
	//	AfxMessageBox("data in buffer 9...");
}




//*****************************************************************************
DWORD CRfid1demoDlg::hex2dec(char *addr)
{
	DWORD a, b, c, d, e, f, g, h;

	if(strlen(addr) == 1)
		return ascitohex(*addr);

	if(strlen(addr) == 2)
	{
		a = ascitohex(*addr) << 4;
		addr++;
		b = ascitohex(*addr);
		return a | b;
	}

	if(strlen(addr) == 3)
	{
		a = ascitohex(*addr) << 8;
		addr++;
		b = ascitohex(*addr) << 4;
		addr++;
		c = ascitohex(*addr);
		return a | b | c;
	}

	if(strlen(addr) == 4)
	{
		a = ascitohex(*addr) << 12;
		addr++;
		b = ascitohex(*addr) << 8;
		addr++;
		c = ascitohex(*addr) << 4;
		addr++;
		d = ascitohex(*addr);
		return a | b | c | d;
	}

	if(strlen(addr) == 5)
	{
		a = ascitohex(*addr) << 16;
		addr++;
		b = ascitohex(*addr) << 12;
		addr++;
		c = ascitohex(*addr) << 8;
		addr++;
		d = ascitohex(*addr) << 4;
		addr++;
		e = ascitohex(*addr);
		return a | b | c | d | e;
	}

	if(strlen(addr) == 6)
	{
		a = ascitohex(*addr) << 20;
		addr++;
		b = ascitohex(*addr) << 16;
		addr++;
		c = ascitohex(*addr) << 12;
		addr++;
		d = ascitohex(*addr) << 8;
		addr++;
		e = ascitohex(*addr) << 4;
		addr++;
		f = ascitohex(*addr);
		return a | b | c | d | e | f;
	}

	if(strlen(addr) == 7)
	{
		a = ascitohex(*addr) << 24;
		addr++;
		b = ascitohex(*addr) << 20;
		addr++;
		c = ascitohex(*addr) << 16;
		addr++;
		d = ascitohex(*addr) << 12;
		addr++;
		e = ascitohex(*addr) << 8;
		addr++;
		f = ascitohex(*addr) << 4;
		addr++;
		g = ascitohex(*addr);
		return a | b | c | d | e | f | g;
	}
	
	if(strlen(addr) == 8)
	{
		DWORD x;

		x=0;
		a = ascitohex(*addr) << 28;
		addr++;
		x |= a;
		b = ascitohex(*addr) << 24;
		addr++;
		x |= b;
		c = ascitohex(*addr) << 20;
		addr++;
		x |= c;
		d = ascitohex(*addr) << 16;
		addr++;
		x |= d;
		e = ascitohex(*addr) << 12;
		addr++;
		x |= e;
		f = ascitohex(*addr) << 8;
		addr++;
		x |= f;
		g = ascitohex(*addr) << 4;
		addr++;
		x |= g;
		h = ascitohex(*addr);
		x |= h;

		//x = a | b | c | d | e | f | g | h; 

		return x;
	}

	return 0;
}

//**********************************************************************
void CRfid1demoDlg::Read8Blocks(int section) //read 8 4-byte blocks starting at section
{
	char str_src[3000];
	char str_dest[3000];
	DWORD x;
	unsigned char tx[1000];//, rx[1000];//, strr[300];
	DWORD ret_bytes;
	CString stra, str;

	for(x=0; x<2000; x++)
		grx[x] = 0;

	for(x=0; x<3000; x++)
	{
		str_src[x] = 0;
		str_dest[x] = 0;
	}

	//build and send the Read block command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x43;//C

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x38;//8
		
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x33;//3

	if(section==0)//block 0-7
	{	
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
	}
	if(section==1)//block 8-15
	{	
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x38;//8
	}
	if(section==2)//block 16-23
	{	
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x30;//0
	}
	if(section==3)//block 24-31
	{	
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x38;//8
	}

	if(section==4)//block 32-39
	{	
		tx[pos++] = 0x32;//2
		tx[pos++] = 0x30;//0
	}
	if(section==5)//block 40-47
	{	
		tx[pos++] = 0x32;//2
		tx[pos++] = 0x38;//8
	}
	if(section==6)//block 48-55
	{	
		tx[pos++] = 0x33;//3
		tx[pos++] = 0x30;//0
	}
	if(section==7)//block 56-63
	{	
		tx[pos++] = 0x33;//3
		tx[pos++] = 0x38;//8
	}
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x37;//7
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	PurgePort();
    cp->PutBuffer(tx, pos);
	//debug here
	ret_bytes = FastRead(143, 100);

	if(ret_bytes != 143)
	{
		str.Format("(No Tag Found)");
		UpdateData(TRUE);
		m_MyText+=str;
		UpdateData(FALSE);
		UpdateWindow();


		//Initialize port ********************
		GFLineStatus ls( cp ); 

		//set DTR
		ls.Dtr( GCPP_OFF ); 
		Sleep(5); 
		//Clear DTR
		ls.Dtr( GCPP_ON ); 
		Sleep(150);//wait for micro to start up

		PingReader();
		PurgePort();
		PingReader();
		PurgePort();

		return;
	}


	pos=0;

	while(grx[pos++] != '[')//find starting brace
	{
		if((DWORD)pos>ret_bytes)
		{
			AfxMessageBox("error2");
			return;
		}	
	}

	pos+=4;
	stra.Format("");
	for(x=0; x<8; x++)
	{
		int count=8;
		str.Format("");
		while(count--)
		{
			stra.Format("%c", grx[pos++]);
			str+=stra;
		}
	
		pos+=2;
	
		data8[x] = 0;//init
		if(str.GetLength() ==8)//if a read was performed
		{
			strcpy(str_src, (LPCTSTR)str);
			//byte reverse
			int ptr=6;
			for(int t=0; t<8; t+=2)
			{
				str_dest[t] = str_src[ptr];
				str_dest[t+1] = str_src[ptr+1];
				str_dest[t+2] = NULL;
				ptr-=2;
			}
			data8[x] = hex2dec(str_dest);
		}
	}

	return;
}



//**************************************************************************************
void CRfid1demoDlg::OnButtonread() 
{
	int pos;
	char b1, b2, b3, b4;
	CString str;
	DWORD data;

	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}


	PurgePort();

	UpdateData(TRUE);
	m_MyText = _T("");
	m_PortStatus = _T("Reading Tag...");
	UpdateData(FALSE);
	UpdateWindow();

	//determine the type of tag
	CString single = ReadBothReturnOne();
	if(single.GetLength() < 5)
	{
		m_SniffList.InsertString(0, "Tag not found.");
		UpdateWindow();
		return;
	}

	m_SniffList.InsertString(0, single);
	UpdateWindow();

	CString type;
	type = single.Mid(4, 2);
	int dtype = hex2dec((char *)(LPCTSTR)type);	
	dtype &= 0xFE; //clear the lsb



	SendRegwrtreq(0);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();

	if( (dtype == 0x00) || (dtype == 0x80))//HF-I Plus 
	{
		//change Static text to read 256 Max characters
		GetDlgItem(IDC_STATIC_MAX_COUNT)->SetWindowText("Max:256");

		m_Progress.SetRange(0, 100);
		m_Progress.SetPos(0);

		for(int x=0; x<8; x++)
		{
			pos = (int)((float)x/(float)7.0*100.00);
			m_Progress.SetPos(pos);

			for(int y=0; y<8; y++)
				data8[y]=0;

			Read8Blocks(x);//data stored in data8[x]
			for(y=0; y<8; y++)
			{
				b1 = (data8[y]>>24) & 0x000000FF;
				b2 = (data8[y]>>16) & 0x000000FF;
				b3 = (data8[y]>>8) & 0x000000FF;
				b4 = data8[y] & 0x000000FF;
				str.Format("%c%c%c%c", b1, b2, b3, b4);
				
				UpdateData(TRUE);
				m_MyText+=str;
				UpdateData(FALSE);
				UpdateWindow();
			}
		}
	}
   else//Pro/Standard Read (one block at a time)
   {
		//change Static text to read 32 Max characters
		GetDlgItem(IDC_STATIC_MAX_COUNT)->SetWindowText("Max:32");

	   
	    m_Progress.SetRange(0, 7);
		m_Progress.SetPos(0);

		int error_code;
		for(int loop=0; loop<8; loop++)
		{
			m_Progress.SetPos(loop);
			data = ReadSingleBlock(loop, &error_code);

			b1 = (char)(data>>24) & 0x000000FF;
			b2 = (char)(data>>16) & 0x000000FF;
			b3 = (char)(data>>8) & 0x000000FF;
			b4 = (char)data & 0x000000FF;
			str.Format("%c%c%c%c", b1, b2, b3, b4);
			
			UpdateData(TRUE);
			m_MyText+=str;
			UpdateData(FALSE);
			UpdateWindow();
		}

   }

	OnChangeEditMytext();	
}




//********************************************************************************
void CRfid1demoDlg::OnChangeEditMytext() 
{
	UpdateData(TRUE);
	m_NumChars = m_MyText.GetLength();
	m_PortStatus = _T("Editing...");
	UpdateData(FALSE);
	UpdateWindow();
}




//********************************************************************************
void CRfid1demoDlg::OnButtonClear() 
{
	UpdateData(TRUE);
	m_MyText = _T("");
	UpdateData(FALSE);
	UpdateWindow();
	OnChangeEditMytext();
}




//********************************************************************************
void CRfid1demoDlg::OnButtonWriteTag() 
{
	unsigned char tx[100], rx[100], strj[10], stry[5]; 
	CString strr;
	CString stra, str, pos_str;
	int address, pos;
	DWORD AmountInRxQueue, BytesReturned;


	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}


	UpdateData(TRUE);
	m_PortStatus = _T("Writing Tag...");
	UpdateData(FALSE);
	UpdateWindow();

	
	int uu = m_MyText.GetLength() % 4;
	if(uu ==1) 
		m_MyText += _T("   ");
	if(uu ==2) 
		m_MyText += _T("  ");
	if(uu ==3) 
		m_MyText += _T(" ");

	while(m_MyText.GetLength() <=256)//file out the text with whitespace
		m_MyText += _T("    ");


	SendRegwrtreq(0);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();

	m_Progress.SetRange(0, 100);
	m_Progress.SetPos(0);


	for(address=0; address<m_MyText.GetLength()/4; address++)
	{
		pos = (int)((float)address/(float)64.0*100.00);
		m_Progress.SetPos(pos);

		sprintf((char *)strj, "%02.2X", address);

		int b1 = strj[0];
		int b2 = strj[1];

	
		strr = m_MyText.Mid(address*4, 4);
		

		sprintf((char *)strj, "%s", (LPCTSTR)strr);//This

		sprintf((char *)stry, "%02.2X", strj[0]);
		int b3 = stry[0];
		int b4 = stry[1];

		sprintf((char *)stry, "%02.2X", strj[1]);
		int b5 = stry[0];
		int b6 = stry[1];
		
		sprintf((char *)stry, "%02.2X", strj[2]);
		int b7 = stry[0];
		int b8 = stry[1];
		
		sprintf((char *)stry, "%02.2X", strj[3]);
		int b9 = stry[0];
		int b10 = stry[1];


		//build and send the Read block command
		int pos=0;
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x46;//F

		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x33;//3
		
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x34;//4
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x38;//8
			
		tx[pos++] = 0x34;//4
		tx[pos++] = 0x30;//0

		tx[pos++] = 0x32;//2
		tx[pos++] = 0x31;//1
		tx[pos++] = b1;//addr
		tx[pos++] = b2;//addr
		
		tx[pos++] = b9;//data
		tx[pos++] = b10;//data
		tx[pos++] = b7;//data
		tx[pos++] = b8;//data
		tx[pos++] = b5;//data
		tx[pos++] = b6;//data
		tx[pos++] = b3;//data
		tx[pos++] = b4;//data

		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
	
	    cp->PutBuffer(tx, pos);
		Sleep(50);
		AmountInRxQueue = cp->RXCount();
		BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 

	}

	
	UpdateData(TRUE);
	m_PortStatus = _T("Done.");;
	UpdateData(FALSE);
	UpdateWindow();
}




//********************************************************************************
void CRfid1demoDlg::OnButtonTestPattern() 
{
	unsigned char tx[100], rx[100], strj[10]; 
	CString strr;
	CString stra, str, pos_str;
	int address, pos;
	DWORD AmountInRxQueue, BytesReturned;

	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}


	UpdateData(TRUE);
	m_PortStatus = _T("Writing Test Pattern...");
	UpdateData(FALSE);
	UpdateWindow();


	SendRegwrtreq(0);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();

	m_Progress.SetRange(0, 100);
	m_Progress.SetPos(0);


	for(address=0; address<256; address+=4)
	{
		pos = (int)((float)address/(float)256.0*100.00);
		m_Progress.SetPos(pos);

		sprintf((char *)strj, "%02.2X", address/4);

		int b1 = strj[0];
		int b2 = strj[1];


		//data =  hex2dec((char *)(LPCTSTR)m_Data);	
		sprintf((char *)strj, "%02.2X%02.2X%02.2X%02.2X", address, address+1, address+2, address+3);
		int b3 = strj[0];
		int b4 = strj[1];
		int b5 = strj[2];
		int b6 = strj[3];
		int b7 = strj[4];
		int b8 = strj[5];
		int b9 = strj[6];
		int b10 = strj[7];



		//build and send the Read block command
		int pos=0;
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x46;//F

		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x33;//3
		
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x34;//4
		tx[pos++] = 0x31;//1
		tx[pos++] = 0x38;//8
			
		tx[pos++] = 0x34;//4
		tx[pos++] = 0x30;//0

		tx[pos++] = 0x32;//2
		tx[pos++] = 0x31;//1
		tx[pos++] = b1;//addr
		tx[pos++] = b2;//addr
		
		tx[pos++] = b9;//data
		tx[pos++] = b10;//data
		tx[pos++] = b7;//data
		tx[pos++] = b8;//data
		tx[pos++] = b5;//data
		tx[pos++] = b6;//data
		tx[pos++] = b3;//data
		tx[pos++] = b4;//data

		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		tx[pos++] = 0x30;//0
		
	    cp->PutBuffer(tx, pos);
		Sleep(50);
		AmountInRxQueue = cp->RXCount();
		BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 
	}

	UpdateData(TRUE);
	m_PortStatus = _T("Done.");;
	UpdateData(FALSE);
	UpdateWindow();
}





//**************************************************************************************
void CRfid1demoDlg::OnButtonPassBeep() 
{
	unsigned char tx[600], rx[600];
	CString stra, str;
	DWORD AmountInRxQueue, BytesReturned;


	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}

	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	//debug here
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x37;//7
	tx[pos++] = 0x37;//7
	
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	Sleep(50);
	AmountInRxQueue = cp->RXCount();
	BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 
}




//***************************************************************************
void CRfid1demoDlg::OnButtonFailBeep() 
{
	unsigned char tx[600];
	unsigned char rx[600];
	CString stra, str;
	DWORD AmountInRxQueue, BytesReturned;

	

	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}

	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	//debug here
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x37;//7
	tx[pos++] = 0x39;//9
		
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	/*
	FT_Write(m_ftHandle, tx, pos, &BytesWritten); 
	Sleep(50);
	FT_GetQueueStatus(m_ftHandle, &AmountInRxQueue);
	FT_Read(m_ftHandle, rx, AmountInRxQueue, &BytesReturned);
	*/
    cp->PutBuffer(tx, pos);
	Sleep(50);
	AmountInRxQueue = cp->RXCount();
	BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 

}




//**************************************************************************
void CRfid1demoDlg::WriteSingleBlock(DWORD address, int data) 
{
	unsigned char tx[100], rx[1000], strr[30];
	CString stra, str;
	DWORD AmountInRxQueue, BytesReturned;

	SendRegwrtreq(0);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();

	sprintf((char *)strr, "%02.2X", address);
	int b1 = strr[0];
	int b2 = strr[1];

	sprintf((char *)strr, "%08.8X", data);
	int b3 = strr[0];
	int b4 = strr[1];
	int b5 = strr[2];
	int b6 = strr[3];
	int b7 = strr[4];
	int b8 = strr[5];
	int b9 = strr[6];
	int b10 = strr[7];


	//build and send the Read block command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x46;//F

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x38;//8
		
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x31;//1
	tx[pos++] = b1;//addr
	tx[pos++] = b2;//addr
	
	tx[pos++] = b9;//data
	tx[pos++] = b10;//data
	tx[pos++] = b7;//data
	tx[pos++] = b8;//data
	tx[pos++] = b5;//data
	tx[pos++] = b6;//data
	tx[pos++] = b3;//data
	tx[pos++] = b4;//data

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	Sleep(50);
	AmountInRxQueue = cp->RXCount();
	BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 
}




//**************************************************************************
void CRfid1demoDlg::OnButtonWriteSingle() 
{
	CString stra, str;
	int address, data;

	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}

	UpdateData(TRUE);
	if(m_Addr.GetLength() > 2)
	{
		AfxMessageBox("Invalid Entry.  Range: 00-FF");
		return;
	}

	if(m_Data.GetLength() != 8)
	{
		AfxMessageBox("Invalid Entry.  Range: 00000000-FFFFFFFF");
		return;
	}

	address = hex2dec((char *)(LPCTSTR)m_Addr);	
	data =  hex2dec((char *)(LPCTSTR)m_Data);	

	WriteSingleBlock(address, data);
}




//************************************************************************************
DWORD CRfid1demoDlg::ReadSingleBlock(int addr, int *error) //return hex value
{
	char str_src[3000];
	char str_dest[3000];
	DWORD x;
	unsigned char tx[100], rx[100], strr[3];
	CString stra, str;
	DWORD AmountInRxQueue, BytesReturned;


	*error=0;//init to no error

	SendRegwrtreq(0);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();

	sprintf((char *)strr, "%02.2X", addr);

	int b1 = strr[0];//F
	int b2 = strr[1];//E

	//build and send the Read block command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x42;//B

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x38;//8
		
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x30;//0
	tx[pos++] = b1;//addr
	tx[pos++] = b2;//addr
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
					 
    cp->PutBuffer(tx, pos);
	Sleep(100);
	AmountInRxQueue = cp->RXCount();
	BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 

	for(x=0; x<BytesReturned; x++)
	{
		if(rx[x] == '[')
		{
			x++;
			str.Format(" ");
			while(rx[x] != ']')
			{
				stra.Format("%c", rx[x]);
				x++;
				str+=stra;
			}
		
			if(str.GetLength() >10)//if a read was performed
			{
				strcpy(str_src, (LPCTSTR)str);
				//byte reverse
				int ptr=9;
				for(int t=0; t<8; t+=2)
				{
					str_dest[t] = str_src[ptr];
					str_dest[t+1] = str_src[ptr+1];
					str_dest[t+2] = NULL;
					ptr-=2;
				}

				DWORD x = hex2dec(str_dest);
				return x;
			}
			else
			{
				*error=1;//no data read
				return 0;
			}
		}
	}

	return 0;//default return
}



//************************************************************************************
void CRfid1demoDlg::OnButtonReadBlock() 
{
	CString stra, str;
	int address;
	int error_code;


	UpdateData(TRUE);
	m_Data = _T("");
	UpdateData(FALSE);
	UpdateWindow();


	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}

	if(m_Addr.GetLength() > 2)
	{
		AfxMessageBox("Invalid Entry.  Range: 00-FF");
		return;
	}

	address = hex2dec((char *)(LPCTSTR)m_Addr);	

	DWORD data = ReadSingleBlock(address, &error_code);
	if(error_code)
	{
		AfxMessageBox("ERROR: Invalid data returned.");
		return;
	}

	UpdateData(TRUE);
	m_Data.Format("%08.8X", data);
	UpdateData(FALSE);
	UpdateWindow();
}



//***********************************************************************************
void CRfid1demoDlg::OnButtonStayQuiet() 
{
	unsigned char rx[1000], tx[1000], strr[300];
	DWORD AmountInRxQueue, BytesReturned;
	int nIndex, n;

	CString str, str2;
	KillTimer(100);


	SendRegwrtreq(1);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();


	//int i = m_SniffList.GetCount();
	nIndex = m_SniffList.GetCurSel();
	if(nIndex < 0)
	{
		AfxMessageBox("No tag selected.");
		return;
	}

    n = m_SniffList.GetTextLen( nIndex );
    m_SniffList.GetText( nIndex, str.GetBuffer(n) );
    str.ReleaseBuffer();
    str2.Format(_T("%s"), str.GetBuffer(0));//save the selected string
	str2.Delete(0,4);//chop off the header

	sprintf((char *)strr, "%s", (LPCTSTR)str2);
	int b0 = strr[0];
	int b1 = strr[1];
	int b2 = strr[2];
	int b3 = strr[3];
	int b4 = strr[4];
	int b5 = strr[5];
	int b6 = strr[6];
	int b7 = strr[7];
	int b8 = strr[8];
	int b9 = strr[9];
	int b10 = strr[10];
	int b11 = strr[11];
	int b12 = strr[12];
	int b13 = strr[13];
	int b14 = strr[14];
	int b15 = strr[15];


	//build and send the Read block command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x31;//1
	tx[pos++] = 0x38;//8		
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x32;//2
	
	tx[pos++] = b14;//data
	tx[pos++] = b15;//data
	tx[pos++] = b12;//data
	tx[pos++] = b13;//data
	tx[pos++] = b10;//data
	tx[pos++] = b11;//data
	tx[pos++] = b8;//data
	tx[pos++] = b9;//data
	tx[pos++] = b6;//data
	tx[pos++] = b7;//data
	tx[pos++] = b4;//data
	tx[pos++] = b5;//data
	tx[pos++] = b2;//data
	tx[pos++] = b3;//data
	tx[pos++] = b0;//data
	tx[pos++] = b1;//data

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	Sleep(50);
	AmountInRxQueue = cp->RXCount();
	BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 
}






//**********************************************************************
CString CRfid1demoDlg::ReadBothReturnOne() 
{
	char str_src[3000];
	char str_dest[3000];
	unsigned char tx[3000];
	DWORD ret_bytes, x;
	CString stra, str;
	CString sss;
	int TotNumTags;

	SendRegwrtreq(1);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();

	int ret = PurgePort();

	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x42;//B

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x34;//4
		
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x36;//6
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	
    cp->PutBuffer(tx, pos);
	ret_bytes = GetBufferSlow();

	m_SniffList.ResetContent();
	UpdateWindow();
	TotNumTags=0;

	for(x=0; x<ret_bytes; x++)
	{
		if(grx[x] == '[')
		{
			x++;
			str.Format(" ");
			int indx=0;
			while(grx[x] != ',')
			{
				stra.Format("%c", grx[x]);
				x++;
				indx++;
				str+=stra;
				if(indx>35)
				{
					str.Format(" ");
					break;
				}
			}
		
			if(str.GetLength() >6)//if a UID was found...
			{
				strcpy(str_src, (LPCTSTR)str);

				//byte reverse
				int ptr=15;
				for(int t=0; t<16; t+=2)
				{
					str_dest[t] = str_src[ptr];
					str_dest[t+1] = str_src[ptr+1];
					str_dest[t+2] = NULL;
					ptr-=2;
				}

				sss.Format("%s", str_dest);
				return sss;
			}
		}
	}


	ret = PurgePort();

	//*********************************************
	SendRegwrtreqTagit();
	SendAgcToggle();
	SendAmPmToggle();

	ret = PurgePort();

	//build and send the Register Write Request packet
	pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x42;//B

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x34;//4
		
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x35;//5
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	ret_bytes = GetBufferSlow();

	for(x=0; x<ret_bytes; x++)
	{
		if(grx[x] == '[')
		{
			x++;
			str.Format(" ");
			int indx=0;
			while(grx[x] != ',')
			{
				stra.Format("%c", grx[x]);
				x++;
				indx++;
				str+=stra;
				if(indx>35)
				{
					str.Format(" ");
					break;
				}
			}
		
			if(str.GetLength() >6)//if a UID was found...
			{
				strcpy(str_src, (LPCTSTR)str);

				//byte reverse
				int ptr=19;
				for(int t=0; t<20; t+=2)
				{
					str_dest[t] = str_src[ptr];
					str_dest[t+1] = str_src[ptr+1];
					str_dest[t+2] = NULL;
					ptr-=2;
				}

				sss.Format("%s", str_dest);
				return sss;
			}
		}
	}

	Sleep(40);//wait for any stragglers

	ret = PurgePort();

	sss.Format(" ");
	return sss;
}







//***********************************************************************************
void CRfid1demoDlg::SilenceTag(CString str2) 
{
	unsigned char tx[1000], strr[300];

	SendRegwrtreq(1);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();


	sprintf((char *)strr, "%s", (LPCTSTR)str2);
	int b0 = strr[0];
	int b1 = strr[1];
	int b2 = strr[2];
	int b3 = strr[3];
	int b4 = strr[4];
	int b5 = strr[5];
	int b6 = strr[6];
	int b7 = strr[7];
	int b8 = strr[8];
	int b9 = strr[9];
	int b10 = strr[10];
	int b11 = strr[11];
	int b12 = strr[12];
	int b13 = strr[13];
	int b14 = strr[14];
	int b15 = strr[15];


	//build and send the command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x31;//1
	tx[pos++] = 0x38;//8		
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x32;//2
	
	tx[pos++] = b14;//data
	tx[pos++] = b15;//data
	tx[pos++] = b12;//data
	tx[pos++] = b13;//data
	tx[pos++] = b10;//data
	tx[pos++] = b11;//data
	tx[pos++] = b8;//data
	tx[pos++] = b9;//data
	tx[pos++] = b6;//data
	tx[pos++] = b7;//data
	tx[pos++] = b4;//data
	tx[pos++] = b5;//data
	tx[pos++] = b2;//data
	tx[pos++] = b3;//data
	tx[pos++] = b0;//data
	tx[pos++] = b1;//data

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	int ret = FastRead(63, 50);
}





//**********************************************************************
int CRfid1demoDlg::ReadAndSaveTags() 
{
	char str_src[3000];
	char str_dest[3000];
	unsigned char tx[3000];
	DWORD ret_bytes, x;
	CString stra, str;
	int TotNumTags;




	SendRegwrtreq(1);//0=usermem, 1=UID  //15693 setup
	SendAgcToggle();
	SendAmPmToggle();

	int ret = PurgePort();

	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x42;//B

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x34;//4
		
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x36;//6
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	ret_bytes = GetBufferSlow();

	TotNumTags=0;

	for(x=0; x<ret_bytes; x++)
	{
		if(grx[x] == '[')
		{
			x++;
			str.Format(" ");
			int indx=0;
			while(grx[x] != ',')
			{
				stra.Format("%c", grx[x]);
				x++;
				indx++;
				str+=stra;
				if(indx>35)
				{
					str.Format(" ");
					break;
				}
			}
		
			if(str.GetLength() >6)//if a UID was found...
			{
				strcpy(str_src, (LPCTSTR)str);

				//byte reverse
				int ptr=15;
				for(int t=0; t<16; t+=2)
				{
					str_dest[t] = str_src[ptr];
					str_dest[t+1] = str_src[ptr+1];
					str_dest[t+2] = NULL;
					ptr-=2;
				}

				CString sss;
				sss.Format("%s", str_dest);
				
				//save to array
				g_str_array[TotNumTags] = sss;
				TotNumTags++;
			}
		}
	}


	ret = PurgePort();

	//*********************************************
	SendRegwrtreqTagit();
	SendAgcToggle();
	SendAmPmToggle();

	ret = PurgePort();

	//build and send the Register Write Request packet
	pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x42;//B

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x34;//4
		
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x35;//5
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	ret_bytes = GetBufferSlow();

	for(x=0; x<ret_bytes; x++)
	{
		if(grx[x] == '[')
		{
			x++;
			str.Format(" ");
			int indx=0;
			while(grx[x] != ',')
			{
				stra.Format("%c", grx[x]);
				x++;
				indx++;
				str+=stra;
				if(indx>35)
				{
					str.Format(" ");
					break;
				}
			}
		
			if(str.GetLength() >6)//if a UID was found...
			{
				strcpy(str_src, (LPCTSTR)str);

				//byte reverse
				int ptr=19;
				for(int t=0; t<20; t+=2)
				{
					str_dest[t] = str_src[ptr];
					str_dest[t+1] = str_src[ptr+1];
					str_dest[t+2] = NULL;
					ptr-=2;
				}

				CString sss;
				sss.Format("%s", str_dest);

				//save to array
				g_str_array[TotNumTags] = sss;

				TotNumTags++;				
			}
		}
	}

	Sleep(40);//wait for any stragglers

	ret = PurgePort();

	return TotNumTags;
}









//****************************************************************************************
void CRfid1demoDlg::OnButtonR1() //relay 1
{
	unsigned char tx[600], rx[600];
	CString stra, str;
	DWORD AmountInRxQueue, BytesReturned;


	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}

	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x32;//2
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	Sleep(50);
	AmountInRxQueue = cp->RXCount();
	BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 

}



//****************************************************************************************
void CRfid1demoDlg::OnButtonR2() //relay 2
{
	unsigned char tx[600], rx[600];
	CString stra, str;
	DWORD AmountInRxQueue, BytesReturned;


	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}

	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	Sleep(50);
	AmountInRxQueue = cp->RXCount();
	BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 
}




//****************************************************************************************
void CRfid1demoDlg::OnButtonR3() 
{
	unsigned char tx[600], rx[600];
	CString stra, str;
	DWORD AmountInRxQueue, BytesReturned;


	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}

	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x34;//4
	
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	Sleep(50);
	AmountInRxQueue = cp->RXCount();
	BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 
}




//****************************************************************************************
void CRfid1demoDlg::OnButtonR4() 
{
	unsigned char tx[600], rx[600];
	CString stra, str;
	DWORD AmountInRxQueue, BytesReturned;


	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}

	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x35;//5
	
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	Sleep(50);
	AmountInRxQueue = cp->RXCount();
	BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 
}



//****************************************************************************************
void CRfid1demoDlg::OnButtonR5() 
{
	unsigned char tx[600], rx[600];
	CString stra, str;
	DWORD AmountInRxQueue, BytesReturned;


	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}

	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x36;//6
	
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	Sleep(50);
	AmountInRxQueue = cp->RXCount();
	BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 
}




//****************************************************************************************
void CRfid1demoDlg::OnButtonR6() 
{
	unsigned char tx[600], rx[600];
	CString stra, str;
	DWORD AmountInRxQueue, BytesReturned;


	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}

	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x37;//7
	
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	Sleep(50);
	AmountInRxQueue = cp->RXCount();
	BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 
}




//****************************************************************************************
void CRfid1demoDlg::OnButtonO1h() //P4.7 high
{
	unsigned char tx[600], rx[600];
	CString stra, str;
	DWORD AmountInRxQueue, BytesReturned;


	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}
	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	Sleep(50);
	AmountInRxQueue = cp->RXCount();
	BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 
}




//****************************************************************************************
void CRfid1demoDlg::OnButtonO1l()  //P4.7 low
{
	unsigned char tx[600], rx[600];
	CString stra, str;
	DWORD AmountInRxQueue, BytesReturned;


	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}
	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x33;//3
	tx[pos++] = 0x31;//1
	
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	Sleep(50);
	AmountInRxQueue = cp->RXCount();
	BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 
}




//****************************************************************************************
void CRfid1demoDlg::OnButtonO2h()  //P1.4 high
{
	unsigned char tx[600], rx[600];
	CString stra, str;
	DWORD AmountInRxQueue, BytesReturned;


	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}
	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x33;//3
	tx[pos++] = 0x32;//2
	
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	Sleep(50);
	AmountInRxQueue = cp->RXCount();
	BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 
}




//****************************************************************************************
void CRfid1demoDlg::OnButtonO2l() //P1.4 low
{
	unsigned char tx[600], rx[600];
	CString stra, str;
	DWORD AmountInRxQueue, BytesReturned;


	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}
	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x33;//3
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	Sleep(50);
	AmountInRxQueue = cp->RXCount();
	BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 
}





//****************************************************************************************
void CRfid1demoDlg::OnButtonReadIo() 
{
		unsigned char tx[600], rx[600];
	CString stra, str;
	DWORD AmountInRxQueue, BytesReturned;

	UpdateData(TRUE);
	m_ReadInputs.Format(" ");
	UpdateData(FALSE);
	UpdateWindow();
	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}
	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x33;//3
	tx[pos++] = 0x35;//5
	
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	Sleep(50);
	AmountInRxQueue = cp->RXCount();
	BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 

	UpdateData(TRUE);
	m_ReadInputs.Format("1:%d  2:%d", rx[0x14], rx[0x15]);
	UpdateData(FALSE);
	UpdateWindow();
}








//***********************************************************************************
void CRfid1demoDlg::OnButtonReset() 
{
	unsigned char rx[1000], tx[1000];
	DWORD AmountInRxQueue, BytesReturned;

//010A 000304 10 00 01 0000

	//build and send the disable command
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x41;//A

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	Sleep(50);
	AmountInRxQueue = cp->RXCount();
	BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 

	/*
	GFLineStatus ls( cp ); 

	//set DTR
	ls.Dtr( GCPP_OFF ); 
	Sleep(5); 

	//Clear DTR
	ls.Dtr( GCPP_ON ); 
	Sleep(900);//wait for micro to start up

	int ret = PingReader();
	if(ret)
		AfxMessageBox("Ping failed.");

	*/
}



/* conversion code
    cp->PutBuffer(tx, pos);
	Sleep(100);
	AmountInRxQueue = cp->RXCount();
	BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 
*/




/*
//*********************************************************************************
void CRfid1demoDlg::SendBeep1() 
{
	DWORD AmountInRxQueue, BytesReturned;
	unsigned char tx[600], rx[6000];
	CString stra, str;
	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4
	tx[pos++] = 0x37;//7
	tx[pos++] = 0x37;//7
		
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	Sleep(100);
	AmountInRxQueue = cp->RXCount();
	BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 
}
*/




//**********************************************************************************************
void CRfid1demoDlg::OnButtonChangePort() 
{
	CPortSel dlg;
	dlg.DoModal();



	OpenPort(1, 1);//reset, beep, notify_open in listbox
}




//****************************************************************************************
void CRfid1demoDlg::OnButtonR7() 
{
	unsigned char tx[600], rx[600];
	CString stra, str;
	DWORD AmountInRxQueue, BytesReturned;


	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}

	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x38;//8
	
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	Sleep(50);
	AmountInRxQueue = cp->RXCount();
	BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 
}




//****************************************************************************************
void CRfid1demoDlg::OnButtonR8() 
{
	unsigned char tx[600], rx[600];
	CString stra, str;
	DWORD AmountInRxQueue, BytesReturned;


	if(valid_port==0)
	{
		KillTimer(100);
		AfxMessageBox("RFID1 Reader not found");
		return;
	}

	
	//build and send the Register Write Request packet
	int pos=0;
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x31;//1
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x39;//9
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x33;//3
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x34;//4

	tx[pos++] = 0x32;//2
	tx[pos++] = 0x39;//9
	
	tx[pos++] = 0x46;//F
	tx[pos++] = 0x30;//0

	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0
	tx[pos++] = 0x30;//0

    cp->PutBuffer(tx, pos);
	Sleep(50);
	AmountInRxQueue = cp->RXCount();
	BytesReturned = cp->GetBuffer(rx, AmountInRxQueue, 100); 
	
}
